<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    DmozRdf XML handle
  ===================================================*/

  function DmozStartElement($parser, $name, $attrs) {
    global $cats, $t, $stack, $val_url, $val_cat;

    // import categories
    if($t=='category') {
      if($name=="narrow") {
        // insert into array
        $cats[] = str_replace("Top/","",addslashes($attrs["r:resource"]));
      }
    }

    // import links
    elseif($t=='link') {
      if($name=='ExternalPage') {
        $val_url = $attrs["about"];
      }
      if($name=='Topic') {
        $val_cat = $attrs["r:id"];
      }
    }
    array_push($stack, $name);
  }

  function DmozStopElement($parser, $name) {
    global $dbConn, $stack, $val_cat, $val_url, $val_title, $val_desc,
      $category_path_list,$cat_id_list;

    if($name=='ExternalPage') {

      // generate pwd
      mt_srand((double)microtime()*1000000);
      $pwd = mt_rand();
      $pwd = substr($pwd, -4, 4);

      $val_cat = addslashes($val_cat);
      $val_title = addslashes($val_title);
      $val_desc = addslashes($val_desc);

      $cat = str_replace("Top/","",$val_cat);
      $count=count($category_path_list);
      $i=0;
      while($i<$count) {
        if($cat==$category_path_list[$i]) {
          $cat_id = $cat_id_list[$i];
          break;
        }
        $i++;
      }

      $query = "insert into idx_link
        (category_id, title, url, description, password, date)
        values ('$cat_id', '$val_title', '$val_url', '$val_desc','$pwd', now())
      ";

      $result = $dbConn->Execute($query);
      if ($result=="") {
        $output = "Error executing query: <br>$query";
      }

      //print "<p>".$query;

      $val_desc = "";
    }
    array_pop($stack);
  }

  function DmozCharData($parser, $data) {
    global $stack, $val_title, $val_desc;

    $data = trim($data);
    if(!empty($data)) {
      if($stack[count($stack)-2]=="ExternalPage" && $stack[count($stack)-1]=="d:Title") {
        $val_title = $data;
      }
      if($stack[count($stack)-2]=="ExternalPage" && $stack[count($stack)-1]=="d:Description") {
        $val_desc = $data;
      }
    }
  }

  function DmozParseXmlFile($parser, $file) {
    if(!file_exists($file))
      die("Can't find file \"$file\".");
    if(!($fp = @fopen($file, "r")))
      die("Can't open file \"$file\".");

    while($data = fread($fp, 32000))
      if(!xml_parse($parser, $data, feof($fp)))
        return(false);

    fclose($fp);
    return(true);
  }


  /*===================================================
    ImportDmozRdf()
  ===================================================*/

  function ImportDmozRdf() {
    global $dbConn, $category_separator, $admin_template_path, $msg, $message;
    global $cats,$category_path_list,$cat_id_list;

    // vars url & form
    global $t,$fmt,$start_id;

    // vars messages

    // vars template
    $category_obj = new clsCategory;
    $category_obj->table_name = "idx_category";
    $category_obj->link_table_name = "idx_link";
    $category_obj->separator = $category_separator;

    // generate list of categoty path along with its id
    $query = "select category_id from idx_category";
    $result = $dbConn->Execute($query);

    while (!$result->EOF) {
      $cat_id = $result->Fields('category_id');
      $category_path = trim($category_obj->GetCategoryPath($cat_id));
      $category_path = str_replace($category_separator,"/",$category_path);
      $category_path = str_replace(" ","_",$category_path);
      $category_path_list[] = $category_path;
      $cat_id_list[] = $cat_id;
      $result->MoveNext();
    }

    $parser = xml_parser_create();
    xml_set_element_handler($parser, "DmozStartElement", "DmozStopElement");
    xml_set_character_data_handler($parser, "DmozCharData");
    xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);

    $ret = DmozParseXmlFile($parser, $_FILES['userfile']['tmp_name']);
    if(!$ret) {
      die(sprintf("<p>XML error: %s at line %d",
      xml_error_string(xml_get_error_code($parser)),
      xml_get_current_line_number($parser)));
    }

    xml_parser_free($parser);


    if($t=='category') {

      // get fields value from array
      $i = 0;
      $count_cats = @count($cats);
      while ($i < $count_cats) {

        // get cat id
        $cat_id = $i+2;

        // get cat name
        $cats[$i] = trim(str_replace("_"," ",$cats[$i]));  // strip _
        $arr = explode("/",$cats[$i]);

        $name = $arr[count($arr)-1];   // the real category name

        // get parent
        // main category
        $count = count($arr);
        if($count==1) {
          $parent_id = 0;
        }
        else {
          // sub category

          // get parent id by comparing the string before last / with name in list
          $j = 0;
          $count_name_list = @count($name_list);
          while ($j < $count_name_list) {
            if($arr[$count-2]==$name_list[$j]) {
              $cats2 = array();
              $cat_path = trim(str_replace("_"," ",$cats[$j]));  // strip _
              $cats2 = explode("/",$cat_path);
              print  $c=count($cats2);

              // compare next upper level if possible
              if($count>1) {
                $its_parent = $cats2[$c-2];
                if($arr[$count-3]==$its_parent) {
                  $parent_id = $id_list[$j];
                }
                else
                  break;
              }
              else {
                $parent_id = $id_list[$j];
                break;
              }
            }
            $j++;
          }
        }

        $name_list[] = $name;     // add into a list
        $id_list[] = $cat_id;

        $i++;

        $query = "insert into idx_category (
          category_id, parent_id, name, description,
          visible, permission, registered_only)
          values ($cat_id, $parent_id, '$name', '',
          '1', '1', '0')";

        $result = $dbConn->Execute($query);
        if ($result=="") {
          $output = "Error executing query: <br>$query";
        }
        //print "<p>".$query;
      }
    }

    elseif($t=='ml') {
      $message = $msg['20541'];
      DisplayTemplate($admin_template_path . "message.html",
        "\$message");
      RunPostFilter(__FILE__);
    }

    print "<p>Done";
    print "<p><a href=db_import.php><b>Back</b></a>";
  }


  /*===================================================
    ShowFormDBImport()
  ===================================================*/

  function ShowFormDBImport() {

    // vars global configuration
    global $admin_template_path;

    // vars url & form

    // vars messages

    // vars template


    DisplayTemplate($admin_template_path . "db_import_form.html");
  }


  /*===================================================
    ProcessFormDBImport()
  ===================================================*/

  function ProcessFormDBImport() {

    // vars global configuration
    global $dbConn, $category_separator, $admin_template_path, $message;

    // vars url & form
    global $t,$fmt,$start_id;

    // vars messages
    global $msg;

    // vars template

    $category_obj = new clsCategory;
    $category_obj->table_name = "idx_category";
    $category_obj->link_table_name = "idx_link";
    $category_obj->separator = $category_separator;

    if($t=='link') $tb = 'idx_link';
    elseif($t=='category') $tb = 'idx_category';
    elseif($t=='ml') $tb = 'idx_mailing_list';

    if($fmt=='gtlinks2' && $t=='link') {

      // generate list of categoty path along with its id
      $query = "select category_id from idx_category";
      $result = $dbConn->Execute($query);

      while(!$result->EOF) {
        $cat_id = $result->Fields('category_id');
        $category_path = trim($category_obj->GetCategoryPath($cat_id));
        $category_path = str_replace($category_separator,"/",$category_path);
        $category_path = str_replace(" ","_",$category_path);
        $category_path_list[] = $category_path;
        $cat_id_list[] = $cat_id;
        $result->MoveNext();
      }
    }

    // get fields name
    $query = "select * from $tb";
    $result = $dbConn->Execute($query);
    $num_rows = $result->RecordCount();
    $num_fields = $result->FieldCount();

    $custom_field_offset = 27;
    if($num_fields>$custom_field_offset) {
      $i=0;
      while($i<$num_fields) {
        $fld = $result->FetchField($i);
        $fields[] = $fld->name;
        $i++;
      }
    }

    if(!empty($_FILES['userfile']['tmp_name'])) {

      // storage for category founded
      $dump_cpath = array();
      $dump_cid = array();

      $current_line = 0;
      $fd = fopen($_FILES['userfile']['tmp_name'], "r");
      while ($buffer = fgets($fd, 100000)) {
        $buffer = trim($buffer);

        if(!empty($buffer)) {

          if($fmt=='tab'||$fmt=='indexulite'||$fmt=='indexu2'||$fmt=='extreme')
            $data = explode("\t",$buffer);
          elseif($fmt=='gtlinks2') $data = explode("|",$buffer);

          // addslashes
          $i=0;
          $count_data = @count($data);
          while ($i < $count_data) {
            $data[$i] = addslashes($data[$i]);
            $i++;
          }

          if($fmt=='tab') {
            if($t=='category') {
              $values = "";
              $i=0;
              while($i<20) {
                if($i!=0) $values .= ",";
                $values .= "'$data[$i]'";
                $i++;
              }

              $query = "insert into $tb values ($values)";
            }

            elseif($t=='ml') {
              $values = "'$data[0]'";
              $query = "insert into $tb (email,status) values ($values,1)";
            }

            elseif($t=='link') {
              $values = "";
              $i=0;
              while($i<$num_fields) {
                if($i!=0) $values .= ",";
                $values .= "'$data[$i]'";
                $i++;
              }

              $query = "insert into $tb values ($values)";
            }
          }  // end of tab delimiter

          elseif($fmt=='indexulite') {
            if($t=='category') {

              $query = "insert into idx_category (
                category_id, parent_id, name, description,
                visible, permission, registered_only)
                values ($data[0], $data[1], '$data[2]', '$data[3]',
                '1', '1', '0')";
            }

            elseif($t=='ml') {
              $message = $msg['20542'];
              DisplayTemplate($admin_template_path . "message.html",
                "\$message");
              RunPostFilter(__FILE__);
            }

            elseif($t=='link') {
              // link_id, hot, new, top_rated, votes, and rating are ignored

              $query = "insert into idx_link
                (category_id, title, url, description, contact_name, email,
                hits, date, bid, pick, password)
                values
                ('$data[1]','$data[2]','$data[3]','$data[4]','$data[5]','$data[6]',
                '$data[7]','$data[10]','$data[11]',
                '$data[15]','$data[16]')
              ";
            }
          }  // end of indexu lite

          elseif($fmt=='indexu2') {
            if($t=='category') {

              $query = "insert into idx_category (
                category_id, parent_id, name, description,
                visible, permission, registered_only)
                values ($data[0], $data[1], '$data[2]', '$data[3]',
                '1', '1', '0')";
            }

            elseif($t=='ml') {
              $query = "insert into idx_mailing_list (email,status) values ('$data[0]',1)";
            }

            elseif($t=='link') {
              // link_id, hot, new, top_rated, votes, and rating are ignored

                $i=$custom_field_offset;
                $j=0;
                unset($fname);
                unset($fval);
                while($i<$num_fields) {
                  $offset = 17+$j;              // 17: indexu 2 custom field offset
                  $fname .= ', '.$fields[$i];
                  $fval .= ',\''.$data[$offset].'\'';
                  $i++; $j++;
                }

              $query = "insert into idx_link
                (category_id, title, url, description, contact_name, email,
                hits, date, bid, pick, password".$fname.")
                values
                ('$data[1]','$data[2]','$data[3]','$data[4]','$data[5]','$data[6]',
                '$data[7]','$data[10]','$data[11]',
                '$data[15]','$data[16]'".$fval.")
              ";
            }
          }  // end of indexu 2



          elseif($fmt=='gtlinks2') {
            if($t=='category') {

              // get category_id
              $cat_id = $data[0];
              $dump_cid[] = $cat_id;



              // get name field and remove _
              $name = $data[1];
              $name = str_replace("_"," ",$name);  // = all category path

              $dump_cpath[] = chop($name);
              //print "<br>".$name;

              $arr = explode("/",$name);
              $count = count($arr);

              $name = $arr[$count-1];   // the real category name

              // get parent
              // main category
              if($count==1) {
                $parent_id = 0;
              }

              // sub category
              else {
                $parent_path = "";
                $j=0;
                while($j<$count-1) {
                  $parent_path .= $arr[$j];
                  if($j!=$count-2)
                    $parent_path .= "/";
                  $j++;
                }
                $parent_path = chop($parent_path);
                //print "<br>".$parent_path;

                // compare $parent_path in $dump_cpath[], get index, go to $dump_cid[]

                $j = 0;
                unset($parent_id);
                $count_dump_cpath = @count($dump_cpath);
                while ($j < $count_dump_cpath) {
                  if(strcmp($parent_path,$dump_cpath[$j])==0) {
                    $parent_id = $dump_cid[$j];
                    break;
                  }
                  $j++;
                }
                //print "<br>cid = $cat_id; pid = $parent_id";
                if(!isset($parent_id)) print "<font color=red><p>ERROR: Parent not found ($data[1])</font>";

              }

              // get description
              $description = $data[2];

              // get meta description
              $meta_desc= $data[4];

              // get meta keyword
              $meta_key= $data[5];

              // query
              $query = "insert into idx_category (
                category_id, parent_id, name, description,
                meta_description, meta_keyword, visible, permission, registered_only)
                values ($cat_id, $parent_id, '$name', '$description',
                '$meta_desc', '$meta_key', '1', '1', '0')";

            }

            elseif($t=='ml') {
              $message = $msg['20543'];
              DisplayTemplate($admin_template_path . "message.html",
                "\$message");
              RunPostFilter(__FILE__);
            }

            elseif($t=='link') {

              // link id is ignored

              // get title
              $title = $data[1];

              // get url
              $url = $data[2];

              // get date
              $date = $data[3];
              $dt = explode("-",$date);
              $d = $dt[0];
              $m = $dt[1];
              $y = $dt[2];

              if($m=='Jan') $m = '1';
              elseif($m=='Feb') $m = '2';
              elseif($m=='Mar') $m = '3';
              elseif($m=='Apr') $m = '4';
              elseif($m=='May') $m = '5';
              elseif($m=='Jun') $m = '6';
              elseif($m=='Jul') $m = '7';
              elseif($m=='Aug') $m = '8';
              elseif($m=='Sep') $m = '9';
              elseif($m=='Oct') $m = '10';
              elseif($m=='Nov') $m = '11';
              elseif($m=='Dec') $m = '12';

              $date = "$y-$m-$d";

              // description
              $description = $data[5];

              // get contact name
              $contact_name = $data[6];

              // get email
              $email = $data[7];

              // get hit
              $hit = $data[8];


              // new, popular, rating and votes are ignored

              // get category id
              // compare category string with category path list

              $cat = $data[4];
              $count=count($category_path_list);
              $i=0;
              while($i<$count) {
                if($cat==$category_path_list[$i]) {
                  $cat_id = $cat_id_list[$i];
                  break;
                }
                $i++;
              }

              // generate pwd
              mt_srand((double)microtime()*1000000);
              $pwd = mt_rand();
              $pwd = substr($pwd, -4, 4);

              if($num_fields==$custom_field_offset)  {
                // have no custom fields
                $query = "insert into idx_link
                  (category_id, title, url, description, contact_name, email, hits, date, password)
                  values ($cat_id, '$title', '$url', '$description', '$contact_name', '$email',
                  '$hits', '$date', '$pwd')
                ";
              }
              elseif($num_fields>$custom_field_offset)  {
                // have custom fields

                $i=$custom_field_offset;
                $j=0;
                unset($fname);
                unset($fval);
                while($i<$num_fields) {
                  $offset = 14+$j;              // 14: gt links 2 custom field offset
                  $fname .= ', '.$fields[$i];
                  $fval .= ',\''.$data[$offset].'\'';
                  $i++; $j++;
                }

                $query = "insert into idx_link
                  (category_id, title, url, description, contact_name, email, hits,
                  date, password".$fname.")
                  values ($cat_id, '$title', '$url', '$description', '$contact_name', '$email',
                  '$hits', '$date', '$pwd'".$fval.")
                ";
              }
            }
          }  // end of gt links 2.0

      // import extreme dmoz extractor file

          elseif($fmt=='extreme') {
            if($t=='category') {

              if($current_line==0) {
                $trim_cat = $data[2]."/";
              }
              else {

                // get category_id
                $cat_id = $data[0];
                $dump_cid[] = $cat_id;

                // get name field and remove _
                $name = str_replace($trim_cat,"",$data[2]);
                $name = str_replace("_"," ",$name);  // = all category path

                $dump_cpath[] = chop($name);
                //print "<br>".$name;

                $arr = explode("/",$name);
                $count = count($arr);

                $name = $arr[$count-1];   // the real category name


                // get parent
                // main category
                if($count==1) {
                  $parent_id = 0;
                }
                // sub category
                else {
                  $parent_path = "";
                  $j=0;
                  while($j<$count-1) {
                    $parent_path .= $arr[$j];
                    if($j!=$count-2)
                    $parent_path .= "/";
                    $j++;
                  }
                  $parent_path = chop($parent_path);
                  //print "<br>".$parent_path;

                  // compare $parent_path in $dump_cpath[], get index, go to $dump_cid[]

                  $j = 0;
                  unset($parent_id);
                  $count_dump_cpath = @count($dump_cpath);
                  while ($j < $count_dump_cpath) {
                    if(strcmp($parent_path,$dump_cpath[$j])==0) {
                      $parent_id = $dump_cid[$j];
                      break;
                    }
                    $j++;
                  }
                  //print "<br>cid = $cat_id; pid = $parent_id";
                  if(!isset($parent_id)) print "<font color=red><p>ERROR: Parent not found ($data[1])</font>";
                }

                //$name = addslashes($name);

                // query
                $query = "insert into idx_category (
                  category_id, parent_id, name, visible, permission, registered_only)
                  values ($cat_id, $parent_id, '$name',
                   '1', '1', '0')";

              }
            }

            elseif($t=='ml') {
              $message = $msg['20544'];
              DisplayTemplate($admin_template_path . "message.html",
                "\$message");
              RunPostFilter(__FILE__);
            }

            elseif($t=='link') {
              if($current_line==0) {
              }
              // link id is ignored

              // get category_id
              $cid = $data[1];

              // get title
              $title = $data[3];

              // get url
              $url = $data[4];

              // description
              $description = $data[5];

              // generate pwd
              mt_srand((double)microtime()*1000000);
              $pwd = mt_rand();
              $pwd = substr($pwd, -4, 4);

              // have no custom fields
              $query = "insert into idx_link
                (category_id, title, url, description, date, password)
                values ($cid, '$title', '$url', '$description',
                now(), '$pwd')
              ";
            }
          }  // end of extreme dmoz extractor

          $result = $dbConn->Execute($query);
          if ($result=="") {
            $output = "Error executing query: <br>$query";
          }

          //print "<p>".$query;
        }

        $current_line++;
      }
    }

    print "<p>Done";
    print "<p><a href=db_import.php><b>Back</b></a>";
  }


  /*===================================================
    main
  ===================================================*/

  include "../application.php";
  ini_set("max_execution_time", "3600");

  RemoveFilter("gzip_compression");
  RunPreFilter(__FILE__);

  DisplayTemplate($admin_template_path . "header.html");

  $stack = array();
  $cats = array();

  $val_url = "";
  $val_title = "";
  $val_desc = "";
  $val_cat = "";

  $category_path_list = array();
  $cat_id_list = array();

  if (empty($pflag)) {
    ShowFormDBImport();
  }
  elseif ($pflag == 'import') {
    if ($fmt == "dmozrdf") {
      ImportDmozRdf();
    }
    else {
      ProcessFormDBImport();
    }
  }
  DisplayTemplate($admin_template_path . "footer.html");

  RunPostFilter(__FILE__);

?>